/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.util.BuildingUtils;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildToolPasteMessage
implements IMessage {
    private BlockState state;
    private boolean complete;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;

    public BuildToolPasteMessage() {
    }

    public BuildToolPasteMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, boolean complete, BlockState state) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.complete = complete;
        this.state = state;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.structureName = buf.func_150789_c(Short.MAX_VALUE);
        this.workOrderName = buf.func_150789_c(Short.MAX_VALUE);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.complete = buf.readBoolean();
        this.state = Block.func_196257_b((int)buf.readInt());
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.structureName);
        buf.func_180714_a(this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeBoolean(this.complete);
        buf.writeInt(Block.func_196246_j((BlockState)this.state));
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        StructureName sn = new StructureName(this.structureName);
        ServerPlayerEntity player = ctxIn.getSender();
        if (!Structures.hasMD5((StructureName)sn)) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Can not build " + this.workOrderName + ": schematic missing!"), player.func_110124_au());
            return;
        }
        if (player.func_184812_l_()) {
            if (this.isHut) {
                BuildToolPasteMessage.handleHut(CompatibilityUtils.getWorldFromEntity((Entity)player), (PlayerEntity)player, sn, this.rotation, this.pos, this.mirror, this.state, this.complete);
                CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.field_70170_p, this.structureName, this.pos, BlockPosUtil.getRotationFromRotations(this.rotation), this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, !this.complete, player);
                IBuilding building = IColonyManager.getInstance().getBuilding(CompatibilityUtils.getWorldFromEntity((Entity)player), this.pos);
                if (building != null) {
                    WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
                    ConstructionTapeHelper.removeConstructionTape(workOrder, CompatibilityUtils.getWorldFromEntity((Entity)player));
                }
            } else {
                StructurePlacementUtils.loadAndPlaceStructureWithRotation((World)ctxIn.getSender().field_70170_p, (String)this.structureName, (BlockPos)this.pos, (Rotation)BlockPosUtil.getRotationFromRotations(this.rotation), (Mirror)(this.mirror ? Mirror.FRONT_BACK : Mirror.NONE), (!this.complete ? 1 : 0) != 0, (ServerPlayerEntity)ctxIn.getSender());
            }
        } else if (this.structureName.contains("supply")) {
            int slot;
            if (player.func_147099_x().func_77444_a(Stats.field_75929_E.func_199076_b((Object)ModItems.supplyChest)) > 0 && !((Boolean)MineColonies.getConfig().getServer().allowInfiniteSupplyChests.get()).booleanValue() && !this.isFreeInstantPlacementMH(player)) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.error.supplyChestAlreadyPlaced", (Object[])new Object[0]);
                return;
            }
            Predicate<ItemStack> searchPredicate = stack -> !stack.func_190926_b();
            if (this.structureName.contains("supplyship")) {
                searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((IItemProvider)ModItems.supplyChest), true, false));
            }
            if (this.structureName.contains("supplycamp")) {
                searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((IItemProvider)ModItems.supplyCamp), true, false));
            }
            if (this.isFreeInstantPlacementMH(player)) {
                searchPredicate = searchPredicate.and(stack -> stack.func_77942_o() && stack.func_77978_p().func_74781_a(Constants.PLACEMENT_NBT) != null && stack.func_77978_p().func_74779_i(Constants.PLACEMENT_NBT).equals(Constants.INSTANT_PLACEMENT));
            }
            if ((slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), searchPredicate)) != -1 && !ItemStackUtils.isEmpty(player.field_71071_by.func_70304_b(slot)).booleanValue()) {
                if (player.func_147099_x().func_77444_a(Stats.field_75929_E.func_199076_b((Object)ModItems.supplyChest)) < 1) {
                    LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.progress.supplies_placed", (Object[])new Object[0]);
                    player.func_71064_a(Stats.field_75929_E.func_199076_b((Object)ModItems.supplyChest), 1);
                    AdvancementTriggers.PLACE_SUPPLY.trigger(player);
                }
                CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.field_70170_p, this.structureName, this.pos, BlockPosUtil.getRotationFromRotations(this.rotation), this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, !this.complete, player);
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.supplyChestDeployer.missing", (Object[])new Object[0]);
            }
        }
    }

    private boolean isFreeInstantPlacementMH(ServerPlayerEntity playerEntity) {
        ItemStack mhItem = playerEntity.func_184614_ca();
        return ItemStackUtils.isEmpty(mhItem) == false && mhItem.func_77978_p() != null && mhItem.func_77978_p().func_74779_i(Constants.PLACEMENT_NBT).equals(Constants.INSTANT_PLACEMENT);
    }

    private static void handleHut(@NotNull World world, @NotNull PlayerEntity player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, BlockState state, boolean complete) {
        Block block;
        IColony tempColony = IColonyManager.getInstance().getClosestColony(world, buildPos);
        if (!complete && tempColony != null && !tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) && IColonyManager.getInstance().isFarEnoughFromColonies(world, buildPos)) {
            return;
        }
        String hut = sn.getSection();
        ItemStack stack = BuildingUtils.getItemStackForHutFromInventory(player.field_71071_by, hut);
        Block block2 = block = stack.func_77973_b() instanceof BlockItem ? ((BlockItem)stack.func_77973_b()).func_179223_d() : null;
        if (block != null && EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
            world.func_175655_b(buildPos, true);
            world.func_175656_a(buildPos, state);
            if (!complete) {
                ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (LivingEntity)player, null, mirror, sn.getStyle());
                BuildToolPasteMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror);
            }
        }
    }

    private static void setupBuilding(@NotNull World world, @NotNull PlayerEntity player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        IBuilding building = IColonyManager.getInstance().getBuilding(world, buildPos);
        if (building == null) {
            Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
        } else {
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.func_200200_C_().getString());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            String name = sn.toString();
            name = name.substring(name.length() - 1);
            try {
                int level = Integer.parseInt(name);
                building.setBuildingLevel(level);
            }
            catch (NumberFormatException e) {
                Log.getLogger().warn("Couldn't parse the level.", (Throwable)e);
            }
            building.setStyle(sn.getStyle());
            if (!(building instanceof IRSComponent)) {
                ConstructionTapeHelper.removeConstructionTape(building.getCorners(), world);
            }
            building.setIsMirrored(mirror);
        }
    }
}

